## Project Summary
Prime Agro Farm is a modern agricultural platform for a leading dairy and livestock breeding facility in Uganda. The project focuses on showcasing services like dairy farming, silage production, training, and cattle breeding, while providing an administrative backend for managing news, gallery items, and leadership information.

## Tech Stack
- **Frontend**: Next.js 15 (App Router), React, Tailwind CSS
- **Animations**: Framer Motion
- **Icons**: Lucide React
- **Backend/Database**: Supabase (Auth, Database, Storage)
- **Email**: EmailJS (Contact forms), Resend (Transactional/Newsletters)
- **Deployment**: Vercel
- **Repository**: `https://github.com/primeagrofarms-web/prime-agrofarms-website.git`

## Architecture
- `src/app`: Next.js App Router pages and API routes
- `src/components`: Reusable UI components (Hero, Services, Stats, etc.)
- `src/lib`: Utility functions and service initializations (Supabase, etc.)
- `public`: Static assets including high-quality farm imagery

## User Preferences
- Clean, modern agricultural aesthetic
- High-impact visuals for farm services
- Automated sync with GitHub for Vercel deployment

## Project Guidelines
- Keep components modular and reusable
- Maintain responsive design for mobile users
- Use Supabase for real-time data features

## Common Patterns
- Framer Motion for scroll-reveal animations
- Lucide React for consistent iconography
- Next.js Server Components for data fetching where possible
